/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.tree.featuer;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.worldgen.tree.featuer.AbstractTreeFeatuer;

public class PrismFeature
extends AbstractTreeFeatuer {
    private static final Direction[] ALLFACE = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final int height = 19;
    private final int randHeight = 24;
    private final boolean isSmall;
    private final int data;

    public PrismFeature(int data, boolean isSmall) {
        this.data = data;
        this.isSmall = isSmall;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> con) {
        BlockPos pos = con.m_159777_();
        WorldGenLevel world = con.m_159774_();
        if (!this.checkBlock(world.m_8055_(pos.m_7495_()).m_60734_())) {
            return false;
        }
        for (Direction face : ALLFACE) {
            if (this.checkBlock(world.m_8055_(pos.m_121945_(face).m_7495_()).m_60734_())) continue;
            return false;
        }
        BlockState log = this.getLog();
        BlockState leave = this.getLeave();
        Random rand = new Random();
        this.setBlock(world, pos, AIR);
        if (this.isSmall) {
            this.setBlock(world, pos, log);
            this.setBlock(world, pos.m_122012_(), leave);
            this.setBlock(world, pos.m_122019_(), leave);
            this.setBlock(world, pos.m_122029_(), leave);
            this.setBlock(world, pos.m_122024_(), leave);
            this.setBlock(world, pos.m_7494_(), leave);
            return true;
        }
        int maxHeight = rand.nextInt(this.randHeight) + this.randHeight;
        this.subTrunk(world, rand, pos.m_122012_(), log);
        this.subTrunk(world, rand, pos.m_122019_(), log);
        this.subTrunk(world, rand, pos.m_122024_(), log);
        this.subTrunk(world, rand, pos.m_122029_(), log);
        for (int y = 0; y < maxHeight; ++y) {
            this.setBlock(world, pos.m_6630_(y), log);
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = this.height; y <= maxHeight - 4; ++y) {
                    boolean isOverZ;
                    if (rand.nextInt(20) != 0) continue;
                    this.setleave(world, this.offset(pos, x, y, z), log, leave);
                    boolean isOverX = x == 2 || x == -2;
                    boolean bl = isOverZ = z == 2 || z == -2;
                    if (isOverX && isOverZ) {
                        this.setBlock(world, this.offset(pos, x / 2, y - 1, z / 2), log);
                        continue;
                    }
                    if (isOverX) {
                        this.setBlock(world, this.offset(pos, x / 2, y - 1, z), log);
                        continue;
                    }
                    if (!isOverZ) continue;
                    this.setBlock(world, this.offset(pos, x, y - 1, z / 2), log);
                }
            }
        }
        BlockPos top = this.offset(pos, 0.0, maxHeight - 1, 0.0);
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                this.setBlock(world, top.m_7918_(x, 0, z), leave);
            }
        }
        this.setAir(world, top.m_7918_(-2, 0, -2), leave);
        this.setAir(world, top.m_7918_(2, 0, -2), leave);
        this.setAir(world, top.m_7918_(-2, 0, 2), leave);
        this.setAir(world, top.m_7918_(2, 0, 2), leave);
        this.setBlock(world, top.m_7918_(0, 1, -1), leave);
        this.setBlock(world, top.m_7918_(-1, 1, 0), leave);
        this.setBlock(world, top.m_7918_(0, 1, 1), leave);
        this.setBlock(world, top.m_7918_(1, 1, 0), leave);
        this.setBlock(world, top.m_7494_(), leave);
        this.setBlock(world, top.m_6630_(2), leave);
        if (leave.m_60734_() == BlockInit.maple_leaves) {
            BlockState cherry_blossoms = (BlockState)BlockInit.maple_leaves_carpet.m_49966_().m_61124_((Property)ISMCrop.AGE5, (Comparable)((Integer)leave.m_61143_((Property)ISMCrop.AGE5)));
            for (int x = -6; x <= 6; ++x) {
                for (int z = -6; z <= 6; ++z) {
                    float chance;
                    float f = chance = Math.abs(x) <= 2 && Math.abs(z) <= 2 ? 0.725f : 0.275f;
                    if (x == 0 && z == 0 || rand.nextFloat() >= chance) continue;
                    this.setSMBlock(world, this.offset(pos, x, 0.0, z), cherry_blossoms);
                }
            }
            if (world.m_213780_().m_188501_() >= 0.33f) {
                world.m_7731_(pos.m_6630_(1), (BlockState)BlockInit.maple_hole_log.m_49966_().m_61124_((Property)BaseFaceBlock.FACING, (Comparable)ALLFACE[world.m_213780_().m_188503_(4)]), 3);
            }
        }
        return true;
    }

    public void subTrunk(WorldGenLevel world, Random rand, BlockPos pos, BlockState state) {
        for (int y = 0; y <= rand.nextInt(6) + 8; ++y) {
            this.setBlock(world, pos.m_6630_(y), state);
        }
    }

    public void setleave(WorldGenLevel world, BlockPos pos, BlockState log, BlockState leave) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                this.setBlock(world, this.offset(pos, x, 0.0, z), leave);
                this.setBlock(world, this.offset(pos, x, 1.0, z), leave);
            }
        }
        this.setAir(world, this.offset(pos, -1.0, 1.0, -1.0), leave);
        this.setAir(world, this.offset(pos, 1.0, 1.0, -1.0), leave);
        this.setAir(world, this.offset(pos, -1.0, 1.0, 1.0), leave);
        this.setAir(world, this.offset(pos, 1.0, 1.0, 1.0), leave);
        this.setBlock(world, pos, log);
    }

    @Override
    public void setAir(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_8055_(pos).m_60734_() == state.m_60734_()) {
            this.setBlock(world, pos, AIR);
        }
    }

    protected void setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_46859_(pos) || state.m_60795_()) {
            world.m_7731_(pos, state, 3);
        }
    }

    @Override
    public BlockState getLog() {
        return switch (this.data) {
            case 1 -> BlockInit.magiawood_log.m_49966_();
            case 2 -> BlockInit.lemon_log.m_49966_();
            case 3 -> BlockInit.orange_log.m_49966_();
            case 4 -> BlockInit.estor_log.m_49966_();
            case 5 -> BlockInit.peach_log.m_49966_();
            case 6 -> BlockInit.chestnut_log.m_49966_();
            case 7 -> BlockInit.maple_log.m_49966_();
            default -> BlockInit.prism_log.m_49966_();
        };
    }

    @Override
    public BlockState getLeave() {
        return switch (this.data) {
            case 1 -> (BlockState)((BlockState)BlockInit.magiawood_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
            case 2 -> (BlockState)BlockInit.lemon_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(0));
            case 3 -> (BlockState)BlockInit.orange_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(0));
            case 4 -> (BlockState)BlockInit.estor_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(0));
            case 5 -> (BlockState)BlockInit.peach_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE2, (Comparable)Integer.valueOf(0));
            case 6 -> (BlockState)((BlockState)BlockInit.chestnut_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
            case 7 -> (BlockState)((BlockState)((BlockState)BlockInit.maple_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))).m_61124_((Property)ISMCrop.AGE5, (Comparable)Integer.valueOf(new Random().nextInt(6)));
            default -> (BlockState)((BlockState)BlockInit.prism_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
        };
    }

    public void setSMBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_46859_(pos) && this.checkBlock(world.m_8055_(pos.m_7495_()).m_60734_())) {
            this.setBlock(world, pos, state);
        } else {
            BlockPos targetPos;
            int y;
            for (y = 1; y < 4; ++y) {
                targetPos = pos.m_6625_(y);
                if (!world.m_46859_(targetPos) || !this.checkBlock(world.m_8055_(targetPos.m_7495_()).m_60734_())) continue;
                this.setBlock(world, targetPos, state);
                return;
            }
            for (y = 1; y < 2; ++y) {
                targetPos = pos.m_6630_(y);
                if (!world.m_46859_(targetPos) || !this.checkBlock(world.m_8055_(targetPos.m_7495_()).m_60734_())) continue;
                this.setBlock(world, targetPos, state);
                return;
            }
        }
    }
}

