/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityHorseBase;
import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import com.breakinblocks.horsepowered.recipes.ChoppingRecipe;
import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChopperBlockEntity
extends HPBlockEntityHorseBase {
    private int currentWindup;
    private int currentItemChopTime;
    private int totalItemChopTime;
    private float visualWindup = 0.0f;

    public ChopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.CHOPPER_BE.get(), pos, state, 2);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("currentWindup", this.currentWindup);
        tag.putInt("chopTime", this.currentItemChopTime);
        tag.putInt("totalChopTime", this.totalItemChopTime);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.currentWindup = tag.getInt("currentWindup");
        if (!this.getItem(0).isEmpty()) {
            this.currentItemChopTime = tag.getInt("chopTime");
            this.totalItemChopTime = tag.getInt("totalChopTime");
        } else {
            this.currentItemChopTime = 0;
            this.totalItemChopTime = 1;
        }
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index != 0) {
            return false;
        }
        if (!this.getItem(1).isEmpty() || !this.getItem(0).isEmpty()) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        HPRecipeInput input = new HPRecipeInput(stack);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.CHOPPING_TYPE.get(), (RecipeInput)input, this.level).isPresent();
    }

    @Override
    public boolean validateArea() {
        if (this.level == null) {
            return false;
        }
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x <= 1 && x >= -1 && z <= 1 && z >= -1) continue;
                    this.searchPos.add(this.worldPosition.offset(x, 0, z));
                    this.searchPos.add(this.worldPosition.offset(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            BlockState state = this.level.getBlockState(pos);
            if (state.canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void tickServer() {
        super.tickServer();
        this.updateVisualWindup();
    }

    @Override
    protected void tickClient() {
        super.tickClient();
        this.updateVisualWindup();
    }

    private void updateVisualWindup() {
        float windup = (Integer)HorsePowerConfig.pointsForWindup.get() > 0 ? (float)((Integer)HorsePowerConfig.pointsForWindup.get()).intValue() : 1.0f;
        this.visualWindup = -0.74f + 0.74f * ((float)this.currentWindup / (windup - 1.0f));
    }

    @Override
    public boolean targetReached() {
        ++this.currentWindup;
        if (this.currentWindup >= (Integer)HorsePowerConfig.pointsForWindup.get()) {
            this.currentWindup = 0;
            ++this.currentItemChopTime;
            if (this.currentItemChopTime >= this.totalItemChopTime) {
                this.currentItemChopTime = 0;
                this.totalItemChopTime = this.getRecipeTime();
                this.chopItem();
                return true;
            }
        }
        this.setChanged();
        return false;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        boolean isSameItem;
        ItemStack oldStack = this.getItem(slot);
        super.setItem(slot, stack);
        boolean bl = isSameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)oldStack);
        if (slot == 0 && !isSameItem) {
            this.totalItemChopTime = this.getRecipeTime();
            this.currentItemChopTime = 0;
            this.currentWindup = 0;
        }
    }

    private void chopItem() {
        if (this.canWork()) {
            ItemStack input = this.getItem(0);
            ItemStack result = this.getRecipeOutput();
            ItemStack output = this.getItem(1);
            if (output.isEmpty()) {
                this.setItem(1, result.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
                output.grow(result.getCount());
            }
            input.shrink(1);
            this.setChanged();
        }
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.getRecipe().map(r -> ((ChoppingRecipe)r.value()).getResult().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public int getRecipeTime() {
        return this.getRecipe().map(r -> ((ChoppingRecipe)r.value()).getTime()).orElse(1);
    }

    public Optional<RecipeHolder<ChoppingRecipe>> getRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        HPRecipeInput input = new HPRecipeInput(this.getItem(0));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.CHOPPING_TYPE.get(), (RecipeInput)input, this.level);
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    public int getCurrentChopTime() {
        return this.currentItemChopTime;
    }

    public int getTotalChopTime() {
        return this.totalItemChopTime;
    }

    public float getVisualWindup() {
        return this.visualWindup;
    }
}

