/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityBase;
import com.breakinblocks.horsepowered.blocks.BlockFiller;
import com.breakinblocks.horsepowered.blocks.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FillerBlockEntity
extends BlockEntity {
    public FillerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.FILLER_BE.get(), pos, state);
    }

    @Nullable
    public HPBlockEntityBase getFilledTileEntity() {
        if (this.level == null) {
            return null;
        }
        BlockPos filledPos = this.getFilledPos();
        BlockEntity tileEntity = this.level.getBlockEntity(filledPos);
        if (tileEntity instanceof HPBlockEntityBase) {
            return (HPBlockEntityBase)tileEntity;
        }
        return null;
    }

    public BlockPos getFilledPos() {
        if (this.level == null) {
            return this.worldPosition;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (!(state.getBlock() instanceof BlockFiller)) {
            return this.worldPosition;
        }
        Direction facing = (Direction)state.getValue((Property)BlockFiller.FACING);
        return this.worldPosition.relative(facing);
    }

    public void setChanged() {
        HPBlockEntityBase te = this.getFilledTileEntity();
        if (te != null) {
            te.setChanged();
        }
        super.setChanged();
    }
}

