/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityHorseBase;
import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.recipes.GrindstoneRecipe;
import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GrindstoneBlockEntity
extends HPBlockEntityHorseBase {
    private int currentItemMillTime;
    private int totalItemMillTime;
    public ItemStack renderStack = ItemStack.EMPTY;

    public GrindstoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.GRINDSTONE_BE.get(), pos, state, 3);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("millTime", this.currentItemMillTime);
        tag.putInt("totalMillTime", this.totalItemMillTime);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.getItem(0).isEmpty()) {
            this.currentItemMillTime = tag.getInt("millTime");
            this.totalItemMillTime = tag.getInt("totalMillTime");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
        }
    }

    @Override
    public void setChanged() {
        if (this.getItem(0).isEmpty()) {
            this.currentItemMillTime = 0;
        }
        super.setChanged();
    }

    @Override
    public boolean validateArea() {
        if (this.level == null) {
            return false;
        }
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x <= 1 && x >= -1 && z <= 1 && z >= -1) continue;
                    this.searchPos.add(this.worldPosition.offset(x, 0, z));
                    this.searchPos.add(this.worldPosition.offset(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            BlockState state = this.level.getBlockState(pos);
            if (state.canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        ++this.currentItemMillTime;
        if (this.currentItemMillTime >= this.totalItemMillTime) {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = this.getRecipeTime();
            this.millItem();
            return true;
        }
        this.setChanged();
        return false;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getResult().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public ItemStack getRecipeSecondary() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getSecondary().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public int getRecipeSecondaryChance() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getSecondaryChance()).orElse(0);
    }

    @Override
    public int getRecipeTime() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getTime()).orElse(0);
    }

    public Optional<RecipeHolder<GrindstoneRecipe>> getRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        HPRecipeInput input = new HPRecipeInput(this.getItem(0));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.GRINDING_TYPE.get(), (RecipeInput)input, this.level);
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    private void millItem() {
        if (this.canWork()) {
            Optional<RecipeHolder<GrindstoneRecipe>> recipeOpt = this.getRecipe();
            if (recipeOpt.isEmpty()) {
                return;
            }
            GrindstoneRecipe recipe = (GrindstoneRecipe)recipeOpt.get().value();
            ItemStack result = recipe.getResult();
            ItemStack secondary = recipe.getSecondary();
            ItemStack input = this.getItem(0);
            ItemStack output = this.getItem(1);
            ItemStack secondaryOutput = this.getItem(2);
            if (output.isEmpty()) {
                this.setItem(1, result.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
                output.grow(result.getCount());
            }
            this.processSecondaries(secondary, secondaryOutput, recipe.getSecondaryChance());
            input.shrink(1);
            this.setChanged();
        }
    }

    private void processSecondaries(ItemStack secondary, ItemStack secondaryOutput, int chance) {
        if (!(secondary.isEmpty() || this.level == null || chance < 100 && this.level.random.nextInt(100) >= chance)) {
            if (secondaryOutput.isEmpty()) {
                this.setItem(2, secondary.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)secondaryOutput, (ItemStack)secondary)) {
                secondaryOutput.grow(secondary.getCount());
            }
        }
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        boolean isSameItem;
        ItemStack oldStack = this.getItem(slot);
        super.setItem(slot, stack);
        boolean bl = isSameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)oldStack);
        if (slot == 0 && !isSameItem) {
            this.totalItemMillTime = this.getRecipeTime();
            this.currentItemMillTime = 0;
        }
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index != 0) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        HPRecipeInput input = new HPRecipeInput(stack);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.GRINDING_TYPE.get(), (RecipeInput)input, this.level).isPresent();
    }

    @Override
    public int getOutputSlot() {
        return 2;
    }

    public int getCurrentMillTime() {
        return this.currentItemMillTime;
    }

    public int getTotalMillTime() {
        return this.totalItemMillTime;
    }
}

