/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class HPBlockEntityBase
extends BlockEntity
implements Container,
WorldlyContainer {
    protected NonNullList<ItemStack> itemStacks;
    protected Direction forward = Direction.NORTH;

    public HPBlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state);
        this.itemStacks = NonNullList.withSize((int)inventorySize, (Object)ItemStack.EMPTY);
    }

    public abstract int getInventoryStackLimit();

    public abstract boolean isItemValidForSlot(int var1, ItemStack var2);

    public abstract int getOutputSlot();

    public int getInventoryStackLimit(ItemStack stack) {
        return this.getInventoryStackLimit();
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.itemStacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        if (slot >= this.itemStacks.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.itemStacks.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = ContainerHelper.removeItem(this.itemStacks, (int)slot, (int)amount);
        if (!stack.isEmpty()) {
            this.setChanged();
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.itemStacks, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.itemStacks.set(slot, (Object)stack);
        if (slot == 0 && stack.getCount() > this.getMaxStackSize(stack)) {
            stack.setCount(this.getMaxStackSize(stack));
        }
        this.setChanged();
    }

    public int getMaxStackSize(ItemStack stack) {
        return Math.min(this.getInventoryStackLimit(stack), stack.getMaxStackSize());
    }

    public boolean stillValid(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.itemStacks.clear();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.isItemValidForSlot(index, stack);
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            int outputSlot = this.getOutputSlot();
            if (outputSlot == 2) {
                return new int[]{1, 2};
            }
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 && this.isItemValidForSlot(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index > 0;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)registries);
        if (this.canBeRotated() && tag.contains("forward")) {
            this.forward = Direction.byName((String)tag.getString("forward"));
            if (this.forward == null) {
                this.forward = Direction.NORTH;
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)registries);
        if (this.canBeRotated()) {
            tag.putString("forward", this.forward.getName());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean canWork() {
        ItemStack currentSecondary;
        if (this.getItem(0).isEmpty()) {
            return false;
        }
        ItemStack output = this.getRecipeOutput();
        ItemStack secondary = this.getRecipeSecondary();
        if (output.isEmpty()) {
            return false;
        }
        int inputRequired = this.getRecipeInputCount();
        if (this.getItem(0).getCount() < inputRequired) {
            return false;
        }
        ItemStack currentOutput = this.getItem(1);
        if (!currentOutput.isEmpty()) {
            if (!HPBlockEntityBase.canCombine(currentOutput, output)) {
                return false;
            }
            if (currentOutput.getCount() + output.getCount() > currentOutput.getMaxStackSize()) {
                return false;
            }
        }
        if (!secondary.isEmpty() && !(currentSecondary = this.getItem(2)).isEmpty()) {
            if (!HPBlockEntityBase.canCombine(currentSecondary, secondary)) {
                return false;
            }
            if (currentSecondary.getCount() + secondary.getCount() > secondary.getMaxStackSize()) {
                return false;
            }
        }
        return true;
    }

    public ItemStack getRecipeOutput() {
        return ItemStack.EMPTY;
    }

    public ItemStack getRecipeSecondary() {
        return ItemStack.EMPTY;
    }

    public int getRecipeSecondaryChance() {
        return 0;
    }

    public int getRecipeInputCount() {
        return 1;
    }

    public int getRecipeTime() {
        return 0;
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2) && stack1.getCount() <= stack1.getMaxStackSize();
    }

    public boolean canBeRotated() {
        return false;
    }

    public Direction getForward() {
        return this.forward;
    }

    public void setForward(Direction forward) {
        this.forward = forward;
    }
}

