/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class HPBlockEntityHorseBase
extends HPBlockEntityBase {
    protected static final double[][] PATH = new double[][]{{-1.5, -1.5}, {0.0, -1.5}, {1.5, -1.5}, {1.5, 0.0}, {1.5, 1.5}, {0.0, 1.5}, {-1.5, 1.5}, {-1.5, 0.0}};
    protected AABB[] searchAreas = new AABB[8];
    protected List<BlockPos> searchPos = null;
    protected int origin = -1;
    protected int target = -1;
    protected boolean hasWorker = false;
    protected PathfinderMob worker;
    protected CompoundTag nbtWorker;
    protected boolean valid = false;
    protected int validationTimer = 0;
    protected int locateHorseTimer = 0;
    protected boolean running = true;
    protected boolean wasRunning = false;
    protected int highlightTimer = 0;
    public static final int HIGHLIGHT_DURATION = 100;

    public HPBlockEntityHorseBase(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public abstract boolean validateArea();

    public abstract boolean targetReached();

    public abstract int getPositionOffset();

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.target = tag.getInt("target");
        this.origin = tag.getInt("origin");
        this.hasWorker = tag.getBoolean("hasWorker");
        this.valid = tag.getBoolean("valid");
        if (tag.contains("leash")) {
            this.nbtWorker = tag.getCompound("leash");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("target", this.target);
        tag.putInt("origin", this.origin);
        tag.putBoolean("hasWorker", this.hasWorker);
        tag.putBoolean("valid", this.valid);
        if (this.worker != null && this.nbtWorker == null) {
            CompoundTag workerTag = new CompoundTag();
            workerTag.putUUID("UUID", this.worker.getUUID());
            this.nbtWorker = workerTag;
        }
        if (this.nbtWorker != null) {
            tag.put("leash", (Tag)this.nbtWorker);
        }
    }

    private boolean findWorker() {
        if (this.nbtWorker == null || this.level == null) {
            return false;
        }
        UUID uuid = this.nbtWorker.getUUID("UUID");
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        AABB searchArea = new AABB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0);
        List allCreatures = this.level.getEntitiesOfClass(PathfinderMob.class, searchArea);
        for (PathfinderMob creature : allCreatures) {
            if (!creature.getUUID().equals(uuid)) continue;
            this.setWorker(creature);
            creature.setPersistenceRequired();
            return true;
        }
        return false;
    }

    public void setWorker(PathfinderMob newWorker) {
        this.hasWorker = true;
        this.worker = newWorker;
        this.worker.restrictTo(this.worldPosition, 5);
        this.worker.setPersistenceRequired();
        this.target = this.getClosestTarget();
        if (this.worker != null) {
            CompoundTag workerTag = new CompoundTag();
            workerTag.putUUID("UUID", this.worker.getUUID());
            this.nbtWorker = workerTag;
        }
        this.setChanged();
    }

    public void setWorkerToPlayer(Player player) {
        if (this.hasWorker() && this.worker.canBeLeashed()) {
            this.hasWorker = false;
            this.worker.clearRestriction();
            this.worker.setLeashedTo((Entity)player, true);
            this.worker = null;
            this.nbtWorker = null;
            this.setChanged();
        }
    }

    public boolean hasWorker() {
        if (this.worker != null && this.worker.isAlive() && !this.worker.isLeashed() && this.worker.distanceToSqr(Vec3.atCenterOf((Vec3i)this.worldPosition)) < 45.0) {
            return true;
        }
        if (this.worker != null) {
            if (this.level != null && !this.level.isClientSide) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ(), (ItemStack)new ItemStack((ItemLike)Items.LEAD));
            }
            this.worker = null;
            this.nbtWorker = null;
        }
        this.hasWorker = false;
        return false;
    }

    public boolean hasWorkerForDisplay() {
        if (this.worker != null && this.worker.isAlive() && !this.worker.isLeashed()) {
            return true;
        }
        return this.hasWorker || this.nbtWorker != null;
    }

    public PathfinderMob getWorker() {
        return this.worker;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void showWorkingAreaHighlight() {
        this.highlightTimer = 100;
    }

    public boolean shouldShowHighlight() {
        return this.highlightTimer > 0;
    }

    public List<Map.Entry<BlockPos, Boolean>> getWorkingAreaPositions() {
        ArrayList<Map.Entry<BlockPos, Boolean>> positions = new ArrayList<Map.Entry<BlockPos, Boolean>>();
        if (this.level == null) {
            return positions;
        }
        if (this.searchPos == null) {
            this.validateArea();
        }
        if (this.searchPos != null) {
            for (BlockPos pos : this.searchPos) {
                BlockState state = this.level.getBlockState(pos);
                boolean isClear = state.canBeReplaced();
                positions.add(Map.entry(pos, isClear));
            }
        }
        return positions;
    }

    private Vec3 getPathPosition(int i) {
        double x = (double)this.worldPosition.getX() + 0.5 + PATH[i][0] * 2.0;
        double y = this.worldPosition.getY() + this.getPositionOffset();
        double z = (double)this.worldPosition.getZ() + 0.5 + PATH[i][1] * 2.0;
        return new Vec3(x, y, z);
    }

    protected int getClosestTarget() {
        if (this.hasWorker()) {
            double dist = Double.MAX_VALUE;
            int closest = 0;
            for (int i = 0; i < PATH.length; ++i) {
                Vec3 pos = this.getPathPosition(i);
                double tmp = this.worker.distanceToSqr(pos.x, pos.y, pos.z);
                if (!(tmp < dist)) continue;
                dist = tmp;
                closest = i;
            }
            return closest;
        }
        return 0;
    }

    public static <T extends HPBlockEntityHorseBase> void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        blockEntity.tickServer();
    }

    public static <T extends HPBlockEntityHorseBase> void clientTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        blockEntity.tickClient();
    }

    protected void tickClient() {
        if (this.highlightTimer > 0) {
            --this.highlightTimer;
        }
        if (this.worker == null && this.nbtWorker != null && this.level != null) {
            this.findWorkerClient();
        }
    }

    private void findWorkerClient() {
        if (this.nbtWorker == null || this.level == null || !this.nbtWorker.contains("UUID")) {
            return;
        }
        UUID uuid = this.nbtWorker.getUUID("UUID");
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        AABB searchArea = new AABB((double)x - 10.0, (double)y - 10.0, (double)z - 10.0, (double)x + 10.0, (double)y + 10.0, (double)z + 10.0);
        List creatures = this.level.getEntitiesOfClass(PathfinderMob.class, searchArea);
        for (PathfinderMob creature : creatures) {
            if (!creature.getUUID().equals(uuid)) continue;
            this.worker = creature;
            return;
        }
    }

    protected void tickServer() {
        --this.validationTimer;
        if (this.validationTimer <= 0) {
            boolean wasValid = this.valid;
            this.valid = this.validateArea();
            int n = this.validationTimer = this.valid ? 220 : 60;
            if (wasValid != this.valid) {
                this.setChanged();
            }
        }
        boolean flag = false;
        boolean hasWorkerNow = this.hasWorker();
        if (!hasWorkerNow) {
            --this.locateHorseTimer;
        }
        if (!hasWorkerNow && this.nbtWorker != null && this.locateHorseTimer <= 0) {
            flag = this.findWorker();
        }
        if (this.locateHorseTimer <= 0) {
            this.locateHorseTimer = 120;
        }
        if (this.valid) {
            if (!this.running && this.canWork()) {
                this.running = true;
            } else if (this.running && !this.canWork()) {
                this.running = false;
            }
            if (this.running != this.wasRunning) {
                this.target = this.getClosestTarget();
                this.wasRunning = this.running;
            }
            if (this.hasWorker() && this.running) {
                AbstractHorse horse;
                PathfinderMob pathfinderMob;
                Vec3 pathPos = this.getPathPosition(this.target);
                double x = pathPos.x;
                double y = this.worker.getY();
                double z = pathPos.z;
                this.searchAreas[this.target] = new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 1.5, z + 0.5);
                if (this.worker.getBoundingBox().intersects(this.searchAreas[this.target])) {
                    int next = this.target + 1;
                    int previous = this.target - 1;
                    if (next >= PATH.length) {
                        next = 0;
                    }
                    if (previous < 0) {
                        previous = PATH.length - 1;
                    }
                    if (this.origin != this.target && this.target != previous) {
                        this.origin = this.target;
                        flag = this.targetReached();
                    }
                    this.target = next;
                }
                if ((pathfinderMob = this.worker) instanceof AbstractHorse && (horse = (AbstractHorse)pathfinderMob).isEating()) {
                    horse.setEating(false);
                }
                if (this.target != -1) {
                    double dz;
                    pathPos = this.getPathPosition(this.target);
                    double dx = pathPos.x - this.worker.getX();
                    double dist = Math.sqrt(dx * dx + (dz = pathPos.z - this.worker.getZ()) * dz);
                    if (dist > 0.5) {
                        double speed = 0.12;
                        double stepX = dx / dist * speed;
                        double stepZ = dz / dist * speed;
                        double newX = this.worker.getX() + stepX;
                        double newZ = this.worker.getZ() + stepZ;
                        this.worker.setPos(newX, this.worker.getY(), newZ);
                        float targetYaw = (float)(Math.atan2(-dx, dz) * 57.29577951308232);
                        this.worker.setYRot(targetYaw);
                        this.worker.yBodyRot = targetYaw;
                        this.worker.yHeadRot = targetYaw;
                    }
                }
            }
        }
        if (flag) {
            this.setChanged();
        }
    }
}

