/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityBase;
import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import com.breakinblocks.horsepowered.recipes.GrindstoneRecipe;
import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class HandGrindstoneBlockEntity
extends HPBlockEntityBase {
    private int currentItemMillTime;
    private int totalItemMillTime;
    private static final int TICKS_PER_ROTATION = 18;
    private float visibleRotation = 0.0f;
    private int currentTicks = 0;
    private int rotation = 0;

    public HandGrindstoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.HAND_GRINDSTONE_BE.get(), pos, state, 3);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("millTime", this.currentItemMillTime);
        tag.putInt("totalMillTime", this.totalItemMillTime);
        tag.putInt("currentRotation", this.rotation);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.getItem(0).isEmpty()) {
            this.currentItemMillTime = tag.getInt("millTime");
            this.totalItemMillTime = tag.getInt("totalMillTime");
            this.rotation = tag.getInt("currentRotation");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
            this.rotation = 0;
        }
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getResult().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public ItemStack getRecipeSecondary() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getSecondary().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public int getRecipeSecondaryChance() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getSecondaryChance()).orElse(0);
    }

    @Override
    public int getRecipeTime() {
        return this.getRecipe().map(r -> ((GrindstoneRecipe)r.value()).getTime()).orElse(0);
    }

    public Optional<RecipeHolder<GrindstoneRecipe>> getRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        HPRecipeInput input = new HPRecipeInput(this.getItem(0));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.GRINDING_TYPE.get(), (RecipeInput)input, this.level);
    }

    private void millItem() {
        if (this.level != null && !this.level.isClientSide && this.canWork()) {
            Optional<RecipeHolder<GrindstoneRecipe>> recipeOpt = this.getRecipe();
            if (recipeOpt.isEmpty()) {
                return;
            }
            GrindstoneRecipe recipe = (GrindstoneRecipe)recipeOpt.get().value();
            ItemStack result = recipe.getResult();
            ItemStack secondary = recipe.getSecondary();
            ItemStack input = this.getItem(0);
            ItemStack output = this.getItem(1);
            ItemStack secondaryOutput = this.getItem(2);
            if (output.isEmpty()) {
                this.setItem(1, result.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
                output.grow(result.getCount());
            }
            this.processSecondaries(this.level, secondary, secondaryOutput, recipe.getSecondaryChance());
            input.shrink(1);
            this.setChanged();
        }
    }

    private void processSecondaries(Level world, ItemStack secondary, ItemStack secondaryOutput, int chance) {
        if (!(secondary.isEmpty() || chance < 100 && world.random.nextInt(100) >= chance)) {
            if (secondaryOutput.isEmpty()) {
                this.setItem(2, secondary.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)secondaryOutput, (ItemStack)secondary)) {
                secondaryOutput.grow(secondary.getCount());
            }
        }
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.getItem(0).isEmpty()) {
            this.currentItemMillTime = 0;
        }
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        boolean isSameItem;
        ItemStack oldStack = this.getItem(slot);
        super.setItem(slot, stack);
        boolean bl = isSameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)oldStack);
        if (slot == 0 && !isSameItem) {
            this.totalItemMillTime = this.getRecipeTime();
            this.currentItemMillTime = 0;
        }
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index != 0) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        HPRecipeInput input = new HPRecipeInput(stack);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.GRINDING_TYPE.get(), (RecipeInput)input, this.level).isPresent();
    }

    @Override
    public int getOutputSlot() {
        return 2;
    }

    public int getCurrentMillTime() {
        return this.currentItemMillTime;
    }

    public int getTotalMillTime() {
        return this.totalItemMillTime;
    }

    public boolean turn() {
        if (this.level == null || this.level.isClientSide) {
            return false;
        }
        if (this.rotation < 3 && this.canWork()) {
            this.rotation += 18;
            this.setChanged();
            return true;
        }
        return false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HandGrindstoneBlockEntity blockEntity) {
        blockEntity.tickServer();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HandGrindstoneBlockEntity blockEntity) {
        blockEntity.tickClient();
    }

    private void tickServer() {
        if (this.rotation > 0) {
            ++this.currentTicks;
            if (this.currentTicks >= 18) {
                this.currentTicks -= 18;
                this.currentItemMillTime += ((Integer)HorsePowerConfig.pointsPerRotation.get()).intValue();
                if (this.currentItemMillTime >= this.totalItemMillTime) {
                    this.currentItemMillTime = 0;
                    this.millItem();
                    this.totalItemMillTime = this.getRecipeTime();
                }
                this.setChanged();
            }
            --this.rotation;
        }
    }

    private void tickClient() {
        if (this.rotation > 0) {
            this.visibleRotation = (this.visibleRotation - 20.0f) % -360.0f;
            --this.rotation;
        } else {
            this.visibleRotation = 0.0f;
        }
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }
}

