/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityBase;
import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import com.breakinblocks.horsepowered.recipes.ChoppingRecipe;
import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ManualChopperBlockEntity
extends HPBlockEntityBase {
    private int currentItemChopAmount;
    private int totalItemChopAmount;

    public ManualChopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.CHOPPING_BLOCK_BE.get(), pos, state, 2);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("chopTime", this.currentItemChopAmount);
        tag.putInt("totalChopTime", this.totalItemChopAmount);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.getItem(0).isEmpty()) {
            this.currentItemChopAmount = tag.getInt("chopTime");
            this.totalItemChopAmount = tag.getInt("totalChopTime");
        } else {
            this.currentItemChopAmount = 0;
            this.totalItemChopAmount = 1;
        }
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index != 0) {
            return false;
        }
        if (!this.getItem(1).isEmpty() || !this.getItem(0).isEmpty()) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        HPRecipeInput input = new HPRecipeInput(stack);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.CHOPPING_TYPE.get(), (RecipeInput)input, this.level).isPresent();
    }

    public boolean chop(Player player, ItemStack held) {
        if (this.canWork()) {
            ++this.currentItemChopAmount;
            if (this.currentItemChopAmount >= this.totalItemChopAmount) {
                this.currentItemChopAmount = 0;
                this.totalItemChopAmount = this.getRecipeTime();
                this.chopItem(player);
                return true;
            }
            this.setChanged();
        }
        return false;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        boolean isSameItem;
        ItemStack oldStack = this.getItem(slot);
        super.setItem(slot, stack);
        boolean bl = isSameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)oldStack);
        if (slot == 0 && !isSameItem) {
            this.totalItemChopAmount = this.getRecipeTime() * (Integer)HorsePowerConfig.choppingMultiplier.get();
            this.currentItemChopAmount = 0;
        }
    }

    private void chopItem(Player player) {
        if (this.level == null || !this.canWork()) {
            return;
        }
        ItemStack input = this.getItem(0);
        if (!this.level.isClientSide) {
            ItemStack result = this.getRecipeOutput();
            ItemStack output = this.getItem(1);
            if (((Boolean)HorsePowerConfig.choppingBlockDrop.get()).booleanValue()) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)((double)this.worldPosition.getY() + 0.5), (double)this.worldPosition.getZ(), (ItemStack)result.copy());
            } else if (output.isEmpty()) {
                this.setItem(1, result.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
                output.grow(result.getCount());
            }
        }
        this.level.playSound(player, this.worldPosition, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        input.shrink(1);
        this.setChanged();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.getRecipe().map(r -> ((ChoppingRecipe)r.value()).getResult().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public int getRecipeTime() {
        return this.getRecipe().map(r -> ((ChoppingRecipe)r.value()).getTime()).orElse(1);
    }

    public Optional<RecipeHolder<ChoppingRecipe>> getRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        HPRecipeInput input = new HPRecipeInput(this.getItem(0));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.CHOPPING_TYPE.get(), (RecipeInput)input, this.level);
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    public int getCurrentChopAmount() {
        return this.currentItemChopAmount;
    }

    public int getTotalChopAmount() {
        return this.totalItemChopAmount;
    }
}

