/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blockentity;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityHorseBase;
import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import com.breakinblocks.horsepowered.recipes.PressRecipe;
import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class PressBlockEntity
extends HPBlockEntityHorseBase {
    private final FluidTank tank = new FluidTank((Integer)HorsePowerConfig.pressFluidTankSize.get()){

        protected void onContentsChanged() {
            PressBlockEntity.this.setChanged();
        }
    };
    private int currentPressStatus;

    public PressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.PRESS_BE.get(), pos, state, 2);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("currentPressStatus", this.currentPressStatus);
        tag.put("fluid", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.tank.readFromNBT(registries, tag.getCompound("fluid"));
        this.currentPressStatus = !this.getItem(0).isEmpty() ? tag.getInt("currentPressStatus") : 0;
    }

    @Override
    public void setChanged() {
        if (this.getItem(0).isEmpty()) {
            this.currentPressStatus = 0;
        }
        super.setChanged();
    }

    @Override
    public boolean validateArea() {
        if (this.level == null) {
            return false;
        }
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x <= 1 && x >= -1 && z <= 1 && z >= -1) continue;
                    this.searchPos.add(this.worldPosition.offset(x, 0, z));
                    this.searchPos.add(this.worldPosition.offset(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            BlockState state = this.level.getBlockState(pos);
            if (state.canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        ++this.currentPressStatus;
        int totalPress = (Integer)HorsePowerConfig.pointsForPress.get();
        if (this.currentPressStatus >= (totalPress <= 0 ? 1 : totalPress)) {
            this.currentPressStatus = 0;
            this.pressItem();
            return true;
        }
        this.setChanged();
        return false;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.getRecipe().map(r -> ((PressRecipe)r.value()).getResult().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public int getRecipeInputCount() {
        return this.getRecipe().map(r -> ((PressRecipe)r.value()).getInputCount()).orElse(1);
    }

    public Optional<RecipeHolder<PressRecipe>> getRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        HPRecipeInput input = new HPRecipeInput(this.getItem(0));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.PRESSING_TYPE.get(), (RecipeInput)input, this.level);
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    private void pressItem() {
        if (this.canWork()) {
            Optional<RecipeHolder<PressRecipe>> recipeOpt = this.getRecipe();
            if (recipeOpt.isEmpty()) {
                return;
            }
            PressRecipe recipe = (PressRecipe)recipeOpt.get().value();
            ItemStack result = recipe.getResult();
            FluidStack fluidResult = recipe.getFluidResult();
            ItemStack input = this.getItem(0);
            ItemStack output = this.getItem(1);
            if (recipe.hasFluidOutput()) {
                this.tank.fill(fluidResult.copy(), IFluidHandler.FluidAction.EXECUTE);
            } else if (output.isEmpty()) {
                this.setItem(1, result.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
                output.grow(result.getCount());
            }
            input.shrink(recipe.getInputCount());
            this.setChanged();
        }
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        boolean isSameItem;
        ItemStack oldStack = this.getItem(slot);
        super.setItem(slot, stack);
        boolean bl = isSameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)oldStack);
        if (slot == 0 && !isSameItem) {
            this.currentPressStatus = 0;
        }
    }

    @Override
    public boolean canWork() {
        if (this.getItem(0).isEmpty()) {
            return false;
        }
        Optional<RecipeHolder<PressRecipe>> recipeOpt = this.getRecipe();
        if (recipeOpt.isEmpty()) {
            return false;
        }
        PressRecipe recipe = (PressRecipe)recipeOpt.get().value();
        ItemStack result = recipe.getResult();
        FluidStack fluidOutput = recipe.getFluidResult();
        if (this.getItem(0).getCount() < recipe.getInputCount()) {
            return false;
        }
        if (result.isEmpty() && !recipe.hasFluidOutput()) {
            return false;
        }
        ItemStack output = this.getItem(1);
        if (recipe.hasFluidOutput()) {
            return output.isEmpty() && (this.tank.getFluidAmount() == 0 || this.tank.fill(fluidOutput.copy(), IFluidHandler.FluidAction.SIMULATE) >= fluidOutput.getAmount());
        }
        return this.tank.getFluidAmount() == 0 && (output.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result) && output.getCount() + result.getCount() <= output.getMaxStackSize());
    }

    @Override
    public int getInventoryStackLimit(ItemStack stack) {
        if (this.level == null) {
            return this.getInventoryStackLimit();
        }
        HPRecipeInput input = new HPRecipeInput(stack);
        Optional recipeOpt = this.level.getRecipeManager().getRecipeFor((RecipeType)HPRecipes.PRESSING_TYPE.get(), (RecipeInput)input, this.level);
        return recipeOpt.map(r -> ((PressRecipe)r.value()).getInputCount()).orElse(this.getInventoryStackLimit());
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        return this.currentPressStatus == 0 ? super.removeItemNoUpdate(slot) : ItemStack.EMPTY;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.getRecipe().map(r -> ((PressRecipe)r.value()).getInputCount()).orElse(64);
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index != 0) {
            return false;
        }
        if (this.currentPressStatus != 0) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        return this.level.getRecipeManager().getAllRecipesFor((RecipeType)HPRecipes.PRESSING_TYPE.get()).stream().anyMatch(recipe -> ((PressRecipe)recipe.value()).getIngredient().test(stack));
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getCurrentPressStatus() {
        return this.currentPressStatus;
    }

    public int getTotalPressPoints() {
        int total = (Integer)HorsePowerConfig.pointsForPress.get();
        return total <= 0 ? 1 : total;
    }

    public float getVisualProgress() {
        int total = this.getTotalPressPoints();
        if (total <= 0) {
            return 0.0f;
        }
        return (float)this.currentPressStatus / (float)total;
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }
}

