/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blocks;

import com.breakinblocks.horsepowered.blockentity.FillerBlockEntity;
import com.breakinblocks.horsepowered.blocks.BlockHPBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockFiller
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public BlockFiller(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().noLootTable());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    private boolean validateFilled(Level level, BlockPos fillerPos, BlockState fillerState) {
        BlockPos filledPos = fillerPos.relative((Direction)fillerState.getValue((Property)FACING));
        BlockState filledState = level.getBlockState(filledPos);
        if (filledState.getBlock() instanceof BlockHPBase) {
            return true;
        }
        level.setBlock(fillerPos, Blocks.AIR.defaultBlockState(), 3);
        return false;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (direction == facing && !(neighborState.getBlock() instanceof BlockHPBase)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos filledPos = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState filledState = level.getBlockState(filledPos);
        if (this.validateFilled(level, pos, state)) {
            return filledState.useItemOn(stack, level, player, hand, hit.withPosition(filledPos));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos filledPos = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState filledState = level.getBlockState(filledPos);
        if (this.validateFilled(level, pos, state)) {
            return filledState.useWithoutItem(level, player, hit.withPosition(filledPos));
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos filledPos = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState filledState = level.getBlockState(filledPos);
        if (this.validateFilled(level, pos, state)) {
            level.destroyBlock(filledPos, true);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockPos filledPos = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState filledState = level.getBlockState(filledPos);
        Block block = filledState.getBlock();
        if (block instanceof BlockHPBase) {
            BlockHPBase filledBlock = (BlockHPBase)block;
            return filledBlock.getCloneItemStack(level, filledPos, filledState);
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FillerBlockEntity(pos, state);
    }
}

