/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blocks;

import com.breakinblocks.horsepowered.blockentity.GrindstoneBlockEntity;
import com.breakinblocks.horsepowered.blockentity.HPBlockEntityHorseBase;
import com.breakinblocks.horsepowered.blocks.BlockHPBase;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockGrindstone
extends BlockHPBase {
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    private static final VoxelShape COLLISION_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public BlockGrindstone(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FILLED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    public void emptiedOutput(Level level, BlockPos pos) {
        GrindstoneBlockEntity grindstone;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof GrindstoneBlockEntity && (grindstone = (GrindstoneBlockEntity)be).getItem(1).isEmpty() && grindstone.getItem(2).isEmpty()) {
            BlockGrindstone.setFilled(level, pos, false);
        }
    }

    public static void setFilled(Level level, BlockPos pos, boolean filled) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof BlockGrindstone) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(filled)), 3);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GrindstoneBlockEntity(pos, state);
    }

    @Override
    @Nullable
    protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockState state) {
        if (level.isClientSide) {
            return (lvl, pos, st, be) -> HPBlockEntityHorseBase.clientTick(lvl, pos, st, (GrindstoneBlockEntity)be);
        }
        return (lvl, pos, st, be) -> HPBlockEntityHorseBase.serverTick(lvl, pos, st, (GrindstoneBlockEntity)be);
    }
}

