/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blocks;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityBase;
import com.breakinblocks.horsepowered.blockentity.HPBlockEntityHorseBase;
import com.breakinblocks.horsepowered.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class BlockHPBase
extends Block
implements EntityBlock {
    public BlockHPBase(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
    }

    public boolean isOcclusionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public abstract void emptiedOutput(Level var1, BlockPos var2);

    public int getSlot(BlockState state, float hitX, float hitY, float hitZ) {
        return -1;
    }

    public void onWorkerAttached(Player player, PathfinderMob creature) {
    }

    @Nullable
    protected abstract <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level var1, BlockState var2);

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return this.createTicker(level, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof HPBlockEntityBase) {
                HPBlockEntityHorseBase horseTe;
                HPBlockEntityBase te = (HPBlockEntityBase)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)te);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
                if (te instanceof HPBlockEntityHorseBase && (horseTe = (HPBlockEntityHorseBase)te).hasWorker()) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)Items.LEAD));
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof HPBlockEntityBase)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        HPBlockEntityBase te = (HPBlockEntityBase)blockEntity;
        HPBlockEntityHorseBase horseTE = te instanceof HPBlockEntityHorseBase ? (HPBlockEntityHorseBase)te : null;
        PathfinderMob creature = null;
        if (horseTE != null) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            List<PathfinderMob> creatures = Utils.getValidCreatures(level, new AABB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0));
            for (PathfinderMob mob : creatures) {
                if (!mob.isLeashed() || mob.getLeashHolder() != player) continue;
                creature = mob;
                break;
            }
        }
        if (horseTE != null && (stack.getItem() instanceof LeadItem && creature != null || creature != null)) {
            if (!horseTE.hasWorker()) {
                creature.dropLeash(true, false);
                if (!level.isClientSide) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.LEAD));
                }
                horseTE.setWorker(creature);
                this.onWorkerAttached(player, creature);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.FAIL;
        }
        if (!stack.isEmpty() && te.isItemValidForSlot(0, stack)) {
            ItemStack inputSlot = te.getItem(0);
            if (inputSlot.isEmpty()) {
                te.setItem(0, stack.copy());
                stack.setCount(stack.getCount() - te.getMaxStackSize(stack));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (HPBlockEntityBase.canCombine(inputSlot, stack)) {
                int maxTransfer = Math.min(te.getMaxStackSize(stack), stack.getMaxStackSize()) - inputSlot.getCount();
                int transferAmount = Math.min(stack.getCount(), maxTransfer);
                if (transferAmount > 0) {
                    stack.shrink(transferAmount);
                    inputSlot.grow(transferAmount);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        HPBlockEntityHorseBase horseTE;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof HPBlockEntityBase)) {
            return InteractionResult.PASS;
        }
        HPBlockEntityBase te = (HPBlockEntityBase)blockEntity;
        HPBlockEntityHorseBase hPBlockEntityHorseBase = horseTE = te instanceof HPBlockEntityHorseBase ? (HPBlockEntityHorseBase)te : null;
        if (horseTE != null && player.isShiftKeyDown()) {
            if (level.isClientSide) {
                horseTE.showWorkingAreaHighlight();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        int slot = this.getSlot(state, (float)hit.getLocation().x - (float)pos.getX(), (float)hit.getLocation().y - (float)pos.getY(), (float)hit.getLocation().z - (float)pos.getZ());
        ItemStack result = ItemStack.EMPTY;
        if (slot > -1) {
            result = te.removeItem(slot, te.getItem(slot).getCount());
        } else if (slot > -2) {
            result = te.removeItem(1, te.getItem(1).getCount());
            if (result.isEmpty() && (result = te.removeItem(2, te.getItem(2).getCount())).isEmpty()) {
                result = te.removeItem(0, te.getItem(0).getCount());
            }
            if (!result.isEmpty()) {
                this.emptiedOutput(level, pos);
            }
        }
        if (result.isEmpty() && horseTE != null) {
            horseTE.setWorkerToPlayer(player);
        }
        if (!result.isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
        }
        te.setChanged();
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

