/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.blocks;

import com.breakinblocks.horsepowered.blockentity.HandGrindstoneBlockEntity;
import com.breakinblocks.horsepowered.blocks.BlockHPBase;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockHandGrindstone
extends BlockHPBase {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final VoxelShape COLLISION_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);

    public BlockHandGrindstone(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        if (placer != null && (be = level.getBlockEntity(pos)) instanceof HandGrindstoneBlockEntity) {
            HandGrindstoneBlockEntity grindstone = (HandGrindstoneBlockEntity)be;
            grindstone.setForward(placer.getDirection().getOpposite());
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        HandGrindstoneBlockEntity grindstone;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof HandGrindstoneBlockEntity && (grindstone = (HandGrindstoneBlockEntity)be).canWork() && !player.isShiftKeyDown()) {
            if (!level.isClientSide && grindstone.turn()) {
                player.causeFoodExhaustion(((Double)HorsePowerConfig.grindstoneExhaustion.get()).floatValue());
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    @Override
    public void emptiedOutput(Level level, BlockPos pos) {
    }

    @Override
    public int getSlot(BlockState state, float hitX, float hitY, float hitZ) {
        Direction facing = ((Direction)state.getValue((Property)FACING)).getOpposite();
        if ((double)hitX >= 0.3125 && (double)hitX <= 0.6875 && (double)hitY >= 0.52 && (double)hitZ >= 0.625 && (double)hitZ <= 0.9375) {
            return facing == Direction.NORTH ? 2 : (facing == Direction.SOUTH ? -2 : (facing == Direction.EAST ? 1 : 0));
        }
        if ((double)hitX >= 0.3125 && (double)hitX <= 0.6875 && (double)hitY >= 0.52 && (double)hitZ >= 0.0625 && (double)hitZ <= 0.375) {
            return facing == Direction.NORTH ? -2 : (facing == Direction.SOUTH ? 2 : (facing == Direction.EAST ? 0 : 1));
        }
        if ((double)hitX >= 0.0625 && (double)hitX <= 0.375 && (double)hitY >= 0.52 && (double)hitZ >= 0.3125 && (double)hitZ <= 0.6875) {
            return facing == Direction.NORTH ? 0 : (facing == Direction.SOUTH ? 1 : (facing == Direction.EAST ? 2 : -2));
        }
        if ((double)hitX >= 0.625 && (double)hitX <= 0.9375 && (double)hitY >= 0.52 && (double)hitZ >= 0.3125 && (double)hitZ <= 0.6875) {
            return facing == Direction.NORTH ? 1 : (facing == Direction.SOUTH ? 0 : (facing == Direction.EAST ? -2 : 2));
        }
        return -2;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HandGrindstoneBlockEntity(pos, state);
    }

    @Override
    @Nullable
    protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockState state) {
        if (level.isClientSide) {
            return (lvl, pos, st, be) -> HandGrindstoneBlockEntity.clientTick(lvl, pos, st, (HandGrindstoneBlockEntity)be);
        }
        return (lvl, pos, st, be) -> HandGrindstoneBlockEntity.serverTick(lvl, pos, st, (HandGrindstoneBlockEntity)be);
    }
}

