/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.client.renderer;

import com.breakinblocks.horsepowered.blockentity.ChopperBlockEntity;
import com.breakinblocks.horsepowered.blocks.BlockChopper;
import com.breakinblocks.horsepowered.client.renderer.LeadRenderer;
import com.breakinblocks.horsepowered.client.renderer.RenderUtils;
import com.breakinblocks.horsepowered.client.renderer.WorkingAreaRenderer;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class ChopperBlockEntityRenderer
implements BlockEntityRenderer<ChopperBlockEntity> {
    private static final ResourceLocation STONE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/stone");
    private static final float BLADE_WIDTH = 0.625f;
    private static final float BLADE_DEPTH = 0.125f;
    private static final float BLADE_HEIGHT = 0.1875f;
    private static final float BLADE_MIN_Y = 0.5f;
    private static final float BLADE_MAX_Y = 1.25f;
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private final Font font;

    public ChopperBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(ChopperBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        WorkingAreaRenderer.renderIfActive(blockEntity, poseStack, bufferSource);
        LeadRenderer.renderLead(blockEntity, partialTick, poseStack, bufferSource);
        this.renderBlade(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        ItemStack input = blockEntity.getItem(0);
        ItemStack output = blockEntity.getItem(1);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockChopper.FACING);
        float rotation = this.getRotation(facing);
        if (!input.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.52, 0.5);
            poseStack.scale(0.6f, 0.6f, 0.6f);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemRenderer.renderStatic(input, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (input.getCount() > 1 && ((Boolean)HorsePowerConfig.renderItemAmount.get()).booleanValue()) {
                RenderUtils.renderItemCountBillboard(poseStack, bufferSource, this.font, packedLight, input.getCount(), 0.5, 0.85, 0.5);
            }
        }
        if (!output.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.3, 0.5);
            poseStack.scale(0.4f, 0.4f, 0.4f);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation + 45.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemRenderer.renderStatic(output, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (output.getCount() > 1 && ((Boolean)HorsePowerConfig.renderItemAmount.get()).booleanValue()) {
                RenderUtils.renderItemCountBillboard(poseStack, bufferSource, this.font, packedLight, output.getCount(), 0.5, 0.55, 0.5);
            }
        }
    }

    private float getRotation(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
    }

    private void renderBlade(ChopperBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float windup = blockEntity.getVisualWindup();
        float progress = (windup + 0.74f) / 0.74f;
        float bladeY = 0.5f + 0.75f * progress;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(STONE_TEXTURE);
        VertexConsumer builder = bufferSource.getBuffer(RenderType.solid());
        poseStack.pushPose();
        float halfWidth = 0.3125f;
        float halfDepth = 0.0625f;
        float minX = 0.5f - halfDepth;
        float maxX = 0.5f + halfDepth;
        float minY = bladeY;
        float maxY = bladeY + 0.1875f;
        float minZ = 0.5f - halfWidth;
        float maxZ = 0.5f + halfWidth;
        Matrix4f pose = poseStack.last().pose();
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u1, v0, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u0, v1, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v1, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v0, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u1, v0, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u0, v1, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u1, v0, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u1, v1, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v1, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v0, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u0, v0, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u0, v1, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u1, v0, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v1, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u1, v1, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u0, v0, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v0, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u0, v1, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(ChopperBlockEntity blockEntity) {
        return blockEntity.shouldShowHighlight();
    }

    public int getViewDistance() {
        return 64;
    }
}

