/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.client.renderer;

import com.breakinblocks.horsepowered.blockentity.GrindstoneBlockEntity;
import com.breakinblocks.horsepowered.client.renderer.LeadRenderer;
import com.breakinblocks.horsepowered.client.renderer.RenderUtils;
import com.breakinblocks.horsepowered.client.renderer.WorkingAreaRenderer;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GrindstoneBlockEntityRenderer
implements BlockEntityRenderer<GrindstoneBlockEntity> {
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private final Font font;

    public GrindstoneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(GrindstoneBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        WorkingAreaRenderer.renderIfActive(blockEntity, poseStack, bufferSource);
        LeadRenderer.renderLead(blockEntity, partialTick, poseStack, bufferSource);
        ItemStack input = blockEntity.getItem(0);
        ItemStack output = blockEntity.getItem(1);
        ItemStack secondary = blockEntity.getItem(2);
        if (!input.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 1.1, 0.5);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemRenderer.renderStatic(input, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (input.getCount() > 1 && ((Boolean)HorsePowerConfig.renderItemAmount.get()).booleanValue()) {
                RenderUtils.renderItemCountBillboard(poseStack, bufferSource, this.font, packedLight, input.getCount(), 0.5, 1.4, 0.5);
            }
        }
        if (!output.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.3, 0.25);
            poseStack.scale(0.3f, 0.3f, 0.3f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemRenderer.renderStatic(output, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (output.getCount() > 1 && ((Boolean)HorsePowerConfig.renderItemAmount.get()).booleanValue()) {
                RenderUtils.renderItemCountBillboard(poseStack, bufferSource, this.font, packedLight, output.getCount(), 0.5, 0.55, 0.25);
            }
        }
        if (!secondary.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.3, 0.75);
            poseStack.scale(0.3f, 0.3f, 0.3f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemRenderer.renderStatic(secondary, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (secondary.getCount() > 1 && ((Boolean)HorsePowerConfig.renderItemAmount.get()).booleanValue()) {
                RenderUtils.renderItemCountBillboard(poseStack, bufferSource, this.font, packedLight, secondary.getCount(), 0.5, 0.55, 0.75);
            }
        }
    }

    public boolean shouldRenderOffScreen(GrindstoneBlockEntity blockEntity) {
        return blockEntity.shouldShowHighlight();
    }

    public int getViewDistance() {
        return 64;
    }
}

