/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.client.renderer;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityHorseBase;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class LeadRenderer {
    public static void renderLead(HPBlockEntityHorseBase blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
        PathfinderMob worker = blockEntity.getWorker();
        if (worker == null || !blockEntity.hasWorkerForDisplay()) {
            return;
        }
        BlockPos blockPos = blockEntity.getBlockPos();
        double blockX = 0.5;
        double blockY = 1.0;
        double blockZ = 0.5;
        Vec3 workerPos = worker.getRopeHoldPosition(partialTick);
        double dx = workerPos.x - (double)blockPos.getX() - blockX;
        double dy = workerPos.y - (double)blockPos.getY() - blockY;
        double dz = workerPos.z - (double)blockPos.getZ() - blockZ;
        int blockLight = worker.level().getBrightness(LightLayer.BLOCK, blockEntity.getBlockPos().above());
        int skyLight = worker.level().getBrightness(LightLayer.SKY, blockEntity.getBlockPos().above());
        int workerBlockLight = worker.level().getBrightness(LightLayer.BLOCK, worker.blockPosition());
        int workerSkyLight = worker.level().getBrightness(LightLayer.SKY, worker.blockPosition());
        poseStack.pushPose();
        poseStack.translate(blockX, blockY, blockZ);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.leash());
        Matrix4f matrix = poseStack.last().pose();
        LeadRenderer.renderLeadSegments(matrix, vertexConsumer, dx, dy, dz, blockLight, skyLight, workerBlockLight, workerSkyLight);
        poseStack.popPose();
    }

    private static void renderLeadSegments(Matrix4f matrix, VertexConsumer vertexConsumer, double dx, double dy, double dz, int blockLight, int skyLight, int workerBlockLight, int workerSkyLight) {
        float horizontalDist = Mth.sqrt((float)((float)(dx * dx + dz * dz)));
        float totalDist = Mth.sqrt((float)((float)(dx * dx + dy * dy + dz * dz)));
        float r1 = 0.553f;
        float g1 = 0.38f;
        float b1 = 0.243f;
        float r2 = 0.353f;
        float g2 = 0.18f;
        float b2 = 0.043f;
        int segments = 24;
        for (int i = 0; i < segments; ++i) {
            float t1 = (float)i / (float)segments;
            float t2 = (float)(i + 1) / (float)segments;
            float sag1 = LeadRenderer.calculateSag(t1, totalDist);
            float sag2 = LeadRenderer.calculateSag(t2, totalDist);
            float x1 = (float)(dx * (double)t1);
            float y1 = (float)(dy * (double)t1) - sag1;
            float z1 = (float)(dz * (double)t1);
            float x2 = (float)(dx * (double)t2);
            float y2 = (float)(dy * (double)t2) - sag2;
            float z2 = (float)(dz * (double)t2);
            int light1 = LightTexture.pack((int)((int)Mth.lerp((float)t1, (float)blockLight, (float)workerBlockLight)), (int)((int)Mth.lerp((float)t1, (float)skyLight, (float)workerSkyLight)));
            int light2 = LightTexture.pack((int)((int)Mth.lerp((float)t2, (float)blockLight, (float)workerBlockLight)), (int)((int)Mth.lerp((float)t2, (float)skyLight, (float)workerSkyLight)));
            float width = 0.025f;
            vertexConsumer.addVertex(matrix, x1 - width, y1, z1).setColor(r1, g1, b1, 1.0f).setLight(light1);
            vertexConsumer.addVertex(matrix, x2 - width, y2, z2).setColor(r1, g1, b1, 1.0f).setLight(light2);
            vertexConsumer.addVertex(matrix, x2 + width, y2, z2).setColor(r1, g1, b1, 1.0f).setLight(light2);
            vertexConsumer.addVertex(matrix, x1 + width, y1, z1).setColor(r1, g1, b1, 1.0f).setLight(light1);
            vertexConsumer.addVertex(matrix, x1 - width, y1 - width, z1).setColor(r2, g2, b2, 1.0f).setLight(light1);
            vertexConsumer.addVertex(matrix, x2 - width, y2 - width, z2).setColor(r2, g2, b2, 1.0f).setLight(light2);
            vertexConsumer.addVertex(matrix, x2 + width, y2 - width, z2).setColor(r2, g2, b2, 1.0f).setLight(light2);
            vertexConsumer.addVertex(matrix, x1 + width, y1 - width, z1).setColor(r2, g2, b2, 1.0f).setLight(light1);
        }
    }

    private static float calculateSag(float t, float totalDist) {
        float sagAmount = Math.min(totalDist * 0.1f, 0.5f);
        return 4.0f * sagAmount * t * (1.0f - t);
    }
}

