/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.client.renderer;

import com.breakinblocks.horsepowered.blockentity.PressBlockEntity;
import com.breakinblocks.horsepowered.client.renderer.LeadRenderer;
import com.breakinblocks.horsepowered.client.renderer.RenderUtils;
import com.breakinblocks.horsepowered.client.renderer.WorkingAreaRenderer;
import com.breakinblocks.horsepowered.config.HorsePowerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.joml.Matrix4f;

public class PressBlockEntityRenderer
implements BlockEntityRenderer<PressBlockEntity> {
    private static final ResourceLocation PLANK_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/oak_planks");
    private static final float PLUNGER_WIDTH = 0.75f;
    private static final float PLUNGER_DEPTH = 0.75f;
    private static final float PLUNGER_HEIGHT = 0.125f;
    private static final float PLUNGER_MAX_Y = 0.7f;
    private static final float PLUNGER_MIN_Y = 0.2f;
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private final Font font;

    public PressBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(PressBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        WorkingAreaRenderer.renderIfActive(blockEntity, poseStack, bufferSource);
        LeadRenderer.renderLead(blockEntity, partialTick, poseStack, bufferSource);
        this.renderPlunger(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        ItemStack input = blockEntity.getItem(0);
        ItemStack output = blockEntity.getItem(1);
        FluidTank tank = blockEntity.getTank();
        if (!input.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.35, 0.5);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemRenderer.renderStatic(input, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (input.getCount() > 1 && ((Boolean)HorsePowerConfig.renderItemAmount.get()).booleanValue()) {
                RenderUtils.renderItemCountBillboard(poseStack, bufferSource, this.font, packedLight, input.getCount(), 0.5, 0.65, 0.5);
            }
        }
        if (!output.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.3, 0.5);
            poseStack.scale(0.35f, 0.35f, 0.35f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.itemRenderer.renderStatic(output, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (output.getCount() > 1 && ((Boolean)HorsePowerConfig.renderItemAmount.get()).booleanValue()) {
                RenderUtils.renderItemCountBillboard(poseStack, bufferSource, this.font, packedLight, output.getCount(), 0.5, 0.55, 0.5);
            }
        }
        if (!tank.isEmpty()) {
            this.renderFluid(poseStack, bufferSource, packedLight, tank);
        }
    }

    private void renderFluid(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluidStack);
        if (stillTexture == null) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int color = fluidTypeExtensions.getTintColor(fluidStack);
        float fillPercentage = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        float fluidHeight = 0.1f + fillPercentage * 0.6f;
        poseStack.pushPose();
        poseStack.translate(0.125, 0.1, 0.125);
        VertexConsumer builder = bufferSource.getBuffer(RenderType.translucent());
        Matrix4f matrix = poseStack.last().pose();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a == 0.0f) {
            a = 1.0f;
        }
        float width = 0.75f;
        float u1 = sprite.getU0();
        float u2 = sprite.getU1();
        float v1 = sprite.getV0();
        float v2 = sprite.getV1();
        builder.addVertex(matrix, 0.0f, fluidHeight, 0.0f).setColor(r, g, b, a).setUv(u1, v1).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix, 0.0f, fluidHeight, width).setColor(r, g, b, a).setUv(u1, v2).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix, width, fluidHeight, width).setColor(r, g, b, a).setUv(u2, v2).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix, width, fluidHeight, 0.0f).setColor(r, g, b, a).setUv(u2, v1).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        poseStack.popPose();
    }

    private void renderPlunger(PressBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float progress = blockEntity.getVisualProgress();
        float plungerY = 0.7f - 0.5f * progress;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(PLANK_TEXTURE);
        VertexConsumer builder = bufferSource.getBuffer(RenderType.solid());
        poseStack.pushPose();
        float halfWidth = 0.375f;
        float halfDepth = 0.375f;
        float minX = 0.5f - halfWidth;
        float maxX = 0.5f + halfWidth;
        float minY = plungerY;
        float maxY = plungerY + 0.125f;
        float minZ = 0.5f - halfDepth;
        float maxZ = 0.5f + halfDepth;
        Matrix4f pose = poseStack.last().pose();
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u1, v0, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u0, v1, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v1, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v0, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u1, v0, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u0, v1, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u1, v0, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u1, v1, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v1, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v0, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u0, v0, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u0, v1, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u1, v0, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v1, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u1, v1, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u0, v0, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v0, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u0, v1, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(PressBlockEntity blockEntity) {
        return blockEntity.shouldShowHighlight();
    }

    public int getViewDistance() {
        return 64;
    }
}

