/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static void renderItemCountBillboard(PoseStack poseStack, MultiBufferSource bufferSource, Font font, int packedLight, int count, double x, double y, double z) {
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.02f, -0.02f, 0.02f);
        String text = String.valueOf(count);
        float textX = (float)(-font.width(text)) / 2.0f;
        Matrix4f matrix = poseStack.last().pose();
        font.drawInBatch(text, textX, 0.0f, 0xFFFFFF, true, matrix, bufferSource, Font.DisplayMode.NORMAL, 0x40000000, packedLight);
        poseStack.popPose();
    }

    public static void addVertex(VertexConsumer builder, Matrix4f pose, float x, float y, float z, float u, float v, float nx, float ny, float nz, int packedLight, int packedOverlay) {
        builder.addVertex(pose, x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(packedOverlay).setLight(packedLight).setNormal(nx, ny, nz);
    }

    public static void renderTexturedBox(PoseStack poseStack, MultiBufferSource bufferSource, ResourceLocation textureLocation, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int packedLight, int packedOverlay) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(textureLocation);
        VertexConsumer builder = bufferSource.getBuffer(RenderType.solid());
        Matrix4f pose = poseStack.last().pose();
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u1, v0, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u0, v1, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v1, 0.0f, 1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v0, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u1, v0, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u0, v1, 0.0f, -1.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u1, v0, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u1, v1, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v1, 0.0f, 0.0f, -1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v0, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u0, v0, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u0, v1, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 0.0f, 0.0f, 1.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, maxZ, u1, v0, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, maxY, minZ, u0, v0, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, minZ, u0, v1, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, minX, minY, maxZ, u1, v1, -1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, minZ, u0, v0, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, maxY, maxZ, u1, v0, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, maxZ, u1, v1, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        RenderUtils.addVertex(builder, pose, maxX, minY, minZ, u0, v1, 1.0f, 0.0f, 0.0f, packedLight, packedOverlay);
    }
}

