/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.client.renderer;

import com.breakinblocks.horsepowered.blockentity.HPBlockEntityHorseBase;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class WorkingAreaRenderer {
    public static void renderIfActive(HPBlockEntityHorseBase blockEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (blockEntity.shouldShowHighlight()) {
            WorkingAreaRenderer.render(blockEntity, poseStack, bufferSource);
        }
    }

    public static void render(HPBlockEntityHorseBase blockEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockPos blockPos = blockEntity.getBlockPos();
        List<Map.Entry<BlockPos, Boolean>> positions = blockEntity.getWorkingAreaPositions();
        if (positions.isEmpty()) {
            return;
        }
        WorkingAreaRenderer.renderFilledBoxes(positions, blockPos, poseStack);
        WorkingAreaRenderer.renderWireframes(positions, blockPos, poseStack, bufferSource);
    }

    private static void renderFilledBoxes(List<Map.Entry<BlockPos, Boolean>> positions, BlockPos blockPos, PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (Map.Entry<BlockPos, Boolean> entry : positions) {
            BlockPos pos = entry.getKey();
            boolean isClear = entry.getValue();
            float x = pos.getX() - blockPos.getX();
            float y = pos.getY() - blockPos.getY();
            float z = pos.getZ() - blockPos.getZ();
            int r = isClear ? 0 : 255;
            int g = isClear ? 255 : 0;
            int b = 0;
            int a = 25;
            WorkingAreaRenderer.renderFilledBox(buffer, matrix, x, y, z, x + 1.0f, y + 1.0f, z + 1.0f, r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private static void renderWireframes(List<Map.Entry<BlockPos, Boolean>> positions, BlockPos blockPos, PoseStack poseStack, MultiBufferSource bufferSource) {
        VertexConsumer lineConsumer = bufferSource.getBuffer(RenderType.lines());
        for (Map.Entry<BlockPos, Boolean> entry : positions) {
            BlockPos pos = entry.getKey();
            boolean isClear = entry.getValue();
            double x = pos.getX() - blockPos.getX();
            double y = pos.getY() - blockPos.getY();
            double z = pos.getZ() - blockPos.getZ();
            float r = isClear ? 0.0f : 1.0f;
            float g = isClear ? 1.0f : 0.0f;
            AABB box = new AABB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)lineConsumer, (AABB)box, (float)r, (float)g, (float)0.0f, (float)1.0f);
        }
    }

    private static void renderFilledBox(BufferBuilder buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a) {
        buffer.addVertex(matrix, x1, y1, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y1, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y1, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y1, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y2, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y2, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y1, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y2, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y1, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y1, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y2, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y1, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y1, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y2, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y2, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x1, y1, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y1, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y1, z2).setColor(r, g, b, a);
    }
}

