/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.compat.jade;

import com.breakinblocks.horsepowered.blockentity.ChopperBlockEntity;
import com.breakinblocks.horsepowered.blockentity.FillerBlockEntity;
import com.breakinblocks.horsepowered.blockentity.GrindstoneBlockEntity;
import com.breakinblocks.horsepowered.blockentity.HPBlockEntityBase;
import com.breakinblocks.horsepowered.blockentity.HandGrindstoneBlockEntity;
import com.breakinblocks.horsepowered.blockentity.ManualChopperBlockEntity;
import com.breakinblocks.horsepowered.blockentity.PressBlockEntity;
import com.breakinblocks.horsepowered.blocks.BlockChopper;
import com.breakinblocks.horsepowered.blocks.BlockChoppingBlock;
import com.breakinblocks.horsepowered.blocks.BlockFiller;
import com.breakinblocks.horsepowered.blocks.BlockGrindstone;
import com.breakinblocks.horsepowered.blocks.BlockHandGrindstone;
import com.breakinblocks.horsepowered.blocks.BlockPress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class HorsePowerJadePlugin
implements IWailaPlugin {
    public static final ResourceLocation GRINDSTONE = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"grindstone");
    public static final ResourceLocation CHOPPER = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"chopper");
    public static final ResourceLocation PRESS = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"press");
    public static final ResourceLocation MANUAL = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"manual");
    public static final ResourceLocation FILLER = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"filler");
    private static final String KEY_CURRENT = "hp_current";
    private static final String KEY_TOTAL = "hp_total";
    private static final String KEY_HAS_WORKER = "hp_has_worker";
    private static final String KEY_WORKER_NAME = "hp_worker_name";
    private static final String KEY_IS_VALID = "hp_is_valid";
    private static final String KEY_FLUID_NAME = "hp_fluid_name";
    private static final String KEY_FLUID_AMOUNT = "hp_fluid_amount";
    private static final String KEY_FLUID_CAPACITY = "hp_fluid_capacity";

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag data, BlockAccessor accessor) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof GrindstoneBlockEntity) {
                    GrindstoneBlockEntity te = (GrindstoneBlockEntity)blockEntity;
                    data.putInt(HorsePowerJadePlugin.KEY_CURRENT, te.getCurrentMillTime());
                    data.putInt(HorsePowerJadePlugin.KEY_TOTAL, te.getTotalMillTime());
                    data.putBoolean(HorsePowerJadePlugin.KEY_HAS_WORKER, te.hasWorkerForDisplay());
                    if (te.getWorker() != null) {
                        data.putString(HorsePowerJadePlugin.KEY_WORKER_NAME, te.getWorker().getDisplayName().getString());
                    }
                    data.putBoolean(HorsePowerJadePlugin.KEY_IS_VALID, te.isValid());
                }
            }

            public ResourceLocation getUid() {
                return GRINDSTONE;
            }
        }, GrindstoneBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag data, BlockAccessor accessor) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof ChopperBlockEntity) {
                    ChopperBlockEntity te = (ChopperBlockEntity)blockEntity;
                    data.putInt(HorsePowerJadePlugin.KEY_CURRENT, te.getCurrentChopTime());
                    data.putInt(HorsePowerJadePlugin.KEY_TOTAL, te.getTotalChopTime());
                    data.putBoolean(HorsePowerJadePlugin.KEY_HAS_WORKER, te.hasWorkerForDisplay());
                    if (te.getWorker() != null) {
                        data.putString(HorsePowerJadePlugin.KEY_WORKER_NAME, te.getWorker().getDisplayName().getString());
                    }
                    data.putBoolean(HorsePowerJadePlugin.KEY_IS_VALID, te.isValid());
                }
            }

            public ResourceLocation getUid() {
                return CHOPPER;
            }
        }, ChopperBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag data, BlockAccessor accessor) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof PressBlockEntity) {
                    PressBlockEntity te = (PressBlockEntity)blockEntity;
                    data.putInt(HorsePowerJadePlugin.KEY_CURRENT, te.getCurrentPressStatus());
                    data.putInt(HorsePowerJadePlugin.KEY_TOTAL, te.getTotalPressPoints());
                    data.putBoolean(HorsePowerJadePlugin.KEY_HAS_WORKER, te.hasWorkerForDisplay());
                    if (te.getWorker() != null) {
                        data.putString(HorsePowerJadePlugin.KEY_WORKER_NAME, te.getWorker().getDisplayName().getString());
                    }
                    data.putBoolean(HorsePowerJadePlugin.KEY_IS_VALID, te.isValid());
                    FluidStack fluid = te.getTank().getFluid();
                    if (!fluid.isEmpty()) {
                        data.putString(HorsePowerJadePlugin.KEY_FLUID_NAME, fluid.getHoverName().getString());
                        data.putInt(HorsePowerJadePlugin.KEY_FLUID_AMOUNT, fluid.getAmount());
                        data.putInt(HorsePowerJadePlugin.KEY_FLUID_CAPACITY, te.getTank().getCapacity());
                    }
                }
            }

            public ResourceLocation getUid() {
                return PRESS;
            }
        }, PressBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag data, BlockAccessor accessor) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof FillerBlockEntity) {
                    FillerBlockEntity filler = (FillerBlockEntity)blockEntity;
                    HPBlockEntityBase mainTe = filler.getFilledTileEntity();
                    if (mainTe instanceof ChopperBlockEntity) {
                        ChopperBlockEntity te = (ChopperBlockEntity)mainTe;
                        data.putInt(HorsePowerJadePlugin.KEY_CURRENT, te.getCurrentChopTime());
                        data.putInt(HorsePowerJadePlugin.KEY_TOTAL, te.getTotalChopTime());
                        data.putBoolean(HorsePowerJadePlugin.KEY_HAS_WORKER, te.hasWorkerForDisplay());
                        if (te.getWorker() != null) {
                            data.putString(HorsePowerJadePlugin.KEY_WORKER_NAME, te.getWorker().getDisplayName().getString());
                        }
                        data.putBoolean(HorsePowerJadePlugin.KEY_IS_VALID, te.isValid());
                    } else if (mainTe instanceof PressBlockEntity) {
                        PressBlockEntity te = (PressBlockEntity)mainTe;
                        data.putInt(HorsePowerJadePlugin.KEY_CURRENT, te.getCurrentPressStatus());
                        data.putInt(HorsePowerJadePlugin.KEY_TOTAL, te.getTotalPressPoints());
                        data.putBoolean(HorsePowerJadePlugin.KEY_HAS_WORKER, te.hasWorkerForDisplay());
                        if (te.getWorker() != null) {
                            data.putString(HorsePowerJadePlugin.KEY_WORKER_NAME, te.getWorker().getDisplayName().getString());
                        }
                        data.putBoolean(HorsePowerJadePlugin.KEY_IS_VALID, te.isValid());
                        FluidStack fluid = te.getTank().getFluid();
                        if (!fluid.isEmpty()) {
                            data.putString(HorsePowerJadePlugin.KEY_FLUID_NAME, fluid.getHoverName().getString());
                            data.putInt(HorsePowerJadePlugin.KEY_FLUID_AMOUNT, fluid.getAmount());
                            data.putInt(HorsePowerJadePlugin.KEY_FLUID_CAPACITY, te.getTank().getCapacity());
                        }
                    } else if (mainTe instanceof GrindstoneBlockEntity) {
                        GrindstoneBlockEntity te = (GrindstoneBlockEntity)mainTe;
                        data.putInt(HorsePowerJadePlugin.KEY_CURRENT, te.getCurrentMillTime());
                        data.putInt(HorsePowerJadePlugin.KEY_TOTAL, te.getTotalMillTime());
                        data.putBoolean(HorsePowerJadePlugin.KEY_HAS_WORKER, te.hasWorkerForDisplay());
                        if (te.getWorker() != null) {
                            data.putString(HorsePowerJadePlugin.KEY_WORKER_NAME, te.getWorker().getDisplayName().getString());
                        }
                        data.putBoolean(HorsePowerJadePlugin.KEY_IS_VALID, te.isValid());
                    }
                }
            }

            public ResourceLocation getUid() {
                return FILLER;
            }
        }, FillerBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof GrindstoneBlockEntity) {
                    GrindstoneBlockEntity te = (GrindstoneBlockEntity)blockEntity;
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(2), "secondary");
                    CompoundTag data = accessor.getServerData();
                    HorsePowerJadePlugin.appendProgressFromData(tooltip, data);
                    HorsePowerJadePlugin.appendWorkerInfoFromData(tooltip, data);
                }
            }

            public ResourceLocation getUid() {
                return GRINDSTONE;
            }
        }, BlockGrindstone.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof ChopperBlockEntity) {
                    ChopperBlockEntity te = (ChopperBlockEntity)blockEntity;
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                    CompoundTag data = accessor.getServerData();
                    HorsePowerJadePlugin.appendProgressFromData(tooltip, data);
                    HorsePowerJadePlugin.appendWorkerInfoFromData(tooltip, data);
                }
            }

            public ResourceLocation getUid() {
                return CHOPPER;
            }
        }, BlockChopper.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof PressBlockEntity) {
                    PressBlockEntity te = (PressBlockEntity)blockEntity;
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                    CompoundTag data = accessor.getServerData();
                    if (data.contains(HorsePowerJadePlugin.KEY_FLUID_NAME)) {
                        tooltip.add((Component)Component.translatable((String)"jade.horsepowered.fluid", (Object[])new Object[]{data.getString(HorsePowerJadePlugin.KEY_FLUID_NAME), data.getInt(HorsePowerJadePlugin.KEY_FLUID_AMOUNT), data.getInt(HorsePowerJadePlugin.KEY_FLUID_CAPACITY)}));
                    }
                    HorsePowerJadePlugin.appendProgressFromData(tooltip, data);
                    HorsePowerJadePlugin.appendWorkerInfoFromData(tooltip, data);
                }
            }

            public ResourceLocation getUid() {
                return PRESS;
            }
        }, BlockPress.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof FillerBlockEntity) {
                    FillerBlockEntity filler = (FillerBlockEntity)blockEntity;
                    HPBlockEntityBase mainTe = filler.getFilledTileEntity();
                    if (mainTe instanceof ChopperBlockEntity) {
                        ChopperBlockEntity te = (ChopperBlockEntity)mainTe;
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                    } else if (mainTe instanceof PressBlockEntity) {
                        PressBlockEntity te = (PressBlockEntity)mainTe;
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                    } else if (mainTe instanceof GrindstoneBlockEntity) {
                        GrindstoneBlockEntity te = (GrindstoneBlockEntity)mainTe;
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(2), "secondary");
                    }
                    CompoundTag data = accessor.getServerData();
                    if (data.contains(HorsePowerJadePlugin.KEY_FLUID_NAME)) {
                        tooltip.add((Component)Component.translatable((String)"jade.horsepowered.fluid", (Object[])new Object[]{data.getString(HorsePowerJadePlugin.KEY_FLUID_NAME), data.getInt(HorsePowerJadePlugin.KEY_FLUID_AMOUNT), data.getInt(HorsePowerJadePlugin.KEY_FLUID_CAPACITY)}));
                    }
                    HorsePowerJadePlugin.appendProgressFromData(tooltip, data);
                    HorsePowerJadePlugin.appendWorkerInfoFromData(tooltip, data);
                }
            }

            public ResourceLocation getUid() {
                return FILLER;
            }
        }, BlockFiller.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof HandGrindstoneBlockEntity) {
                    HandGrindstoneBlockEntity te = (HandGrindstoneBlockEntity)blockEntity;
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(2), "secondary");
                } else {
                    blockEntity = accessor.getBlockEntity();
                    if (blockEntity instanceof ManualChopperBlockEntity) {
                        ManualChopperBlockEntity te = (ManualChopperBlockEntity)blockEntity;
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                        HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                    }
                }
            }

            public ResourceLocation getUid() {
                return MANUAL;
            }
        }, BlockHandGrindstone.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (blockEntity instanceof ManualChopperBlockEntity) {
                    ManualChopperBlockEntity te = (ManualChopperBlockEntity)blockEntity;
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(0), "input");
                    HorsePowerJadePlugin.appendItemInfo(tooltip, te.getItem(1), "output");
                }
            }

            public ResourceLocation getUid() {
                return MANUAL;
            }
        }, BlockChoppingBlock.class);
    }

    private static void appendItemInfo(ITooltip tooltip, ItemStack stack, String type) {
        if (!stack.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)("jade.horsepowered." + type), (Object[])new Object[]{stack.getHoverName(), stack.getCount()}));
        }
    }

    private static void appendProgressFromData(ITooltip tooltip, CompoundTag data) {
        int total;
        if (data.contains(KEY_TOTAL) && (total = data.getInt(KEY_TOTAL)) > 0) {
            int current = data.getInt(KEY_CURRENT);
            int percent = current * 100 / total;
            tooltip.add((Component)Component.translatable((String)"jade.horsepowered.progress", (Object[])new Object[]{percent}));
        }
    }

    private static void appendWorkerInfoFromData(ITooltip tooltip, CompoundTag data) {
        if (data.contains(KEY_HAS_WORKER)) {
            if (data.getBoolean(KEY_HAS_WORKER)) {
                if (data.contains(KEY_WORKER_NAME)) {
                    tooltip.add((Component)Component.translatable((String)"jade.horsepowered.worker", (Object[])new Object[]{data.getString(KEY_WORKER_NAME)}));
                } else {
                    tooltip.add((Component)Component.translatable((String)"jade.horsepowered.worker_attached"));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"jade.horsepowered.no_worker"));
            }
        }
        if (data.contains(KEY_IS_VALID) && !data.getBoolean(KEY_IS_VALID)) {
            tooltip.add((Component)Component.translatable((String)"jade.horsepowered.obstructed").withStyle(style -> style.withColor(0xFF5555)));
        }
    }
}

