/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.compat.jei;

import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.compat.jei.HorsePowerPlugin;
import com.breakinblocks.horsepowered.recipes.ChoppingRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HPManualChoppingCategory
implements IRecipeCategory<ChoppingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"manual_chopping");
    private static final int WIDTH = 100;
    private static final int HEIGHT = 60;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final Component title;
    private final List<ItemStack> axes;

    public HPManualChoppingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CHOPPING_BLOCK.get()));
        this.slot = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.getRecipeArrow();
        this.title = Component.translatable((String)"gui.horsepowered.jei.manual_chopping");
        this.axes = BuiltInRegistries.ITEM.getTag(ItemTags.AXES).map(tag -> tag.stream().map(holder -> new ItemStack((ItemLike)holder.value())).toList()).orElse(List.of());
    }

    public RecipeType<ChoppingRecipe> getRecipeType() {
        return HorsePowerPlugin.MANUAL_CHOPPING_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 60;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ChoppingRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 42, 1).addItemStacks(this.axes)).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 26).addIngredients(recipe.getIngredient())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 72, 26).addItemStack(recipe.getResult())).setBackground(this.slot, -1, -1);
    }

    public void draw(ChoppingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 38, 26);
        MutableComponent timeText = Component.translatable((String)"gui.horsepowered.jei.chops", (Object[])new Object[]{recipe.getTime()});
        int textWidth = Minecraft.getInstance().font.width((FormattedText)timeText);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)timeText, (100 - textWidth) / 2, 48, 0x808080, false);
    }
}

