/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.compat.jei;

import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.compat.jei.HorsePowerPlugin;
import com.breakinblocks.horsepowered.recipes.GrindstoneRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HorsePowerGrindingCategory
implements IRecipeCategory<GrindstoneRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"grinding");
    private static final int WIDTH = 100;
    private static final int HEIGHT = 36;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final Component title;

    public HorsePowerGrindingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.GRINDSTONE.get()));
        this.slot = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.getRecipeArrow();
        this.title = Component.translatable((String)"gui.horsepowered.jei.grinding");
    }

    public RecipeType<GrindstoneRecipe> getRecipeType() {
        return HorsePowerPlugin.GRINDING_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 36;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GrindstoneRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.getIngredient())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 1).addItemStack(recipe.getResult())).setBackground(this.slot, -1, -1);
        if (!recipe.getSecondary().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 1).addItemStack(recipe.getSecondary())).setBackground(this.slot, -1, -1).addRichTooltipCallback((slotView, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.horsepowered.jei.chance", (Object[])new Object[]{recipe.getSecondaryChance()})));
        }
    }

    public void draw(GrindstoneRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 26, 1);
        MutableComponent timeText = Component.translatable((String)"gui.horsepowered.jei.time", (Object[])new Object[]{recipe.getTime()});
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)timeText, 1, 24, 0x808080, false);
        if (!recipe.getSecondary().isEmpty() && recipe.getSecondaryChance() > 0) {
            String chanceText = recipe.getSecondaryChance() + "%";
            guiGraphics.drawString(Minecraft.getInstance().font, chanceText, 81, 24, 0x808080, false);
        }
    }
}

