/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.compat.jei;

import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.compat.jei.HPChoppingCategory;
import com.breakinblocks.horsepowered.compat.jei.HPManualChoppingCategory;
import com.breakinblocks.horsepowered.compat.jei.HorsePowerGrindingCategory;
import com.breakinblocks.horsepowered.compat.jei.HorsePowerPressCategory;
import com.breakinblocks.horsepowered.recipes.ChoppingRecipe;
import com.breakinblocks.horsepowered.recipes.GrindstoneRecipe;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import com.breakinblocks.horsepowered.recipes.PressRecipe;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class HorsePowerPlugin
implements IModPlugin {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"jei_plugin");
    public static final RecipeType<GrindstoneRecipe> GRINDING_TYPE = RecipeType.create((String)"horsepowered", (String)"grinding", GrindstoneRecipe.class);
    public static final RecipeType<ChoppingRecipe> CHOPPING_TYPE = RecipeType.create((String)"horsepowered", (String)"chopping", ChoppingRecipe.class);
    public static final RecipeType<ChoppingRecipe> MANUAL_CHOPPING_TYPE = RecipeType.create((String)"horsepowered", (String)"manual_chopping", ChoppingRecipe.class);
    public static final RecipeType<PressRecipe> PRESSING_TYPE = RecipeType.create((String)"horsepowered", (String)"pressing", PressRecipe.class);

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new HorsePowerGrindingCategory(guiHelper), new HPChoppingCategory(guiHelper), new HPManualChoppingCategory(guiHelper), new HorsePowerPressCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List<GrindstoneRecipe> grindingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)HPRecipes.GRINDING_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(GRINDING_TYPE, grindingRecipes);
        List<ChoppingRecipe> choppingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)HPRecipes.CHOPPING_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(CHOPPING_TYPE, choppingRecipes);
        registration.addRecipes(MANUAL_CHOPPING_TYPE, choppingRecipes);
        List<PressRecipe> pressingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)HPRecipes.PRESSING_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(PRESSING_TYPE, pressingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HAND_GRINDSTONE.get()), new RecipeType[]{GRINDING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GRINDSTONE.get()), new RecipeType[]{GRINDING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CHOPPING_BLOCK.get()), new RecipeType[]{MANUAL_CHOPPING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CHOPPER.get()), new RecipeType[]{CHOPPING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PRESS.get()), new RecipeType[]{PRESSING_TYPE});
    }
}

