/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.compat.jei;

import com.breakinblocks.horsepowered.blocks.ModBlocks;
import com.breakinblocks.horsepowered.compat.jei.HorsePowerPlugin;
import com.breakinblocks.horsepowered.recipes.PressRecipe;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HorsePowerPressCategory
implements IRecipeCategory<PressRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"horsepowered", (String)"pressing");
    private static final int WIDTH = 82;
    private static final int HEIGHT = 50;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final Component title;

    public HorsePowerPressCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.PRESS.get()));
        this.slot = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.getRecipeArrow();
        this.title = Component.translatable((String)"gui.horsepowered.jei.pressing");
    }

    public RecipeType<PressRecipe> getRecipeType() {
        return HorsePowerPlugin.PRESSING_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 82;
    }

    public int getHeight() {
        return 50;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PressRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(Arrays.stream(recipe.getIngredient().getItems()).map(stack -> {
            ItemStack copy = stack.copy();
            copy.setCount(recipe.getInputCount());
            return copy;
        }).toList())).setBackground(this.slot, -1, -1);
        if (recipe.hasFluidOutput()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 1).setFluidRenderer((long)recipe.getFluidResult().getAmount(), false, 16, 32).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getFluidResult());
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 1).addItemStack(recipe.getResult())).setBackground(this.slot, -1, -1);
        }
    }

    public void draw(PressRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 26, 1);
        if (recipe.getInputCount() > 1) {
            String countText = "x" + recipe.getInputCount();
            guiGraphics.drawString(Minecraft.getInstance().font, countText, 1, 24, 0x808080, false);
        }
        if (recipe.hasFluidOutput()) {
            String fluidText = recipe.getFluidResult().getAmount() + " mB";
            guiGraphics.drawString(Minecraft.getInstance().font, fluidText, 55, 36, 0x808080, false);
        }
    }
}

