/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.recipes;

import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ChoppingRecipe
implements Recipe<HPRecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final int time;

    public ChoppingRecipe(Ingredient ingredient, ItemStack result, int time) {
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public boolean matches(HPRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack assemble(HPRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)HPRecipes.CHOPPING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)HPRecipes.CHOPPING_TYPE.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer
    implements RecipeSerializer<ChoppingRecipe> {
        public static final MapCodec<ChoppingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(ChoppingRecipe::getIngredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(ChoppingRecipe::getResult), (App)Codec.INT.fieldOf("time").forGetter(ChoppingRecipe::getTime)).apply((Applicative)instance, ChoppingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ChoppingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ChoppingRecipe::getIngredient, (StreamCodec)ItemStack.STREAM_CODEC, ChoppingRecipe::getResult, (StreamCodec)ByteBufCodecs.VAR_INT, ChoppingRecipe::getTime, ChoppingRecipe::new);

        public MapCodec<ChoppingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ChoppingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

