/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.recipes;

import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class GrindstoneRecipe
implements Recipe<HPRecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final ItemStack secondary;
    private final int secondaryChance;
    private final int time;

    public GrindstoneRecipe(Ingredient ingredient, ItemStack result, ItemStack secondary, int secondaryChance, int time) {
        this.ingredient = ingredient;
        this.result = result;
        this.secondary = secondary;
        this.secondaryChance = Math.max(0, Math.min(100, secondaryChance));
        this.time = time;
    }

    public boolean matches(HPRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack assemble(HPRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)HPRecipes.GRINDING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)HPRecipes.GRINDING_TYPE.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack getSecondary() {
        return this.secondary;
    }

    public int getSecondaryChance() {
        return this.secondaryChance;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer
    implements RecipeSerializer<GrindstoneRecipe> {
        public static final MapCodec<GrindstoneRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(GrindstoneRecipe::getIngredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(GrindstoneRecipe::getResult), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("secondary", (Object)ItemStack.EMPTY).forGetter(GrindstoneRecipe::getSecondary), (App)Codec.INT.optionalFieldOf("secondaryChance", (Object)0).forGetter(GrindstoneRecipe::getSecondaryChance), (App)Codec.INT.fieldOf("time").forGetter(GrindstoneRecipe::getTime)).apply((Applicative)instance, GrindstoneRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GrindstoneRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, GrindstoneRecipe::getIngredient, (StreamCodec)ItemStack.STREAM_CODEC, GrindstoneRecipe::getResult, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, GrindstoneRecipe::getSecondary, (StreamCodec)ByteBufCodecs.VAR_INT, GrindstoneRecipe::getSecondaryChance, (StreamCodec)ByteBufCodecs.VAR_INT, GrindstoneRecipe::getTime, GrindstoneRecipe::new);

        public MapCodec<GrindstoneRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GrindstoneRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

