/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.horsepowered.recipes;

import com.breakinblocks.horsepowered.recipes.HPRecipeInput;
import com.breakinblocks.horsepowered.recipes.HPRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class PressRecipe
implements Recipe<HPRecipeInput> {
    private final Ingredient ingredient;
    private final int inputCount;
    private final ItemStack result;
    private final FluidStack fluidResult;

    public PressRecipe(Ingredient ingredient, int inputCount, ItemStack result, FluidStack fluidResult) {
        this.ingredient = ingredient;
        this.inputCount = inputCount;
        this.result = result;
        this.fluidResult = fluidResult;
    }

    public boolean matches(HPRecipeInput input, Level level) {
        ItemStack inputItem = input.getItem(0);
        return this.ingredient.test(inputItem) && inputItem.getCount() >= this.inputCount;
    }

    public ItemStack assemble(HPRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)HPRecipes.PRESSING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)HPRecipes.PRESSING_TYPE.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public FluidStack getFluidResult() {
        return this.fluidResult;
    }

    public boolean hasFluidOutput() {
        return !this.fluidResult.isEmpty();
    }

    public static class Serializer
    implements RecipeSerializer<PressRecipe> {
        public static final MapCodec<PressRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(PressRecipe::getIngredient), (App)Codec.INT.optionalFieldOf("inputCount", (Object)1).forGetter(PressRecipe::getInputCount), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(PressRecipe::getResult), (App)FluidStack.OPTIONAL_CODEC.optionalFieldOf("fluidResult", (Object)FluidStack.EMPTY).forGetter(PressRecipe::getFluidResult)).apply((Applicative)instance, PressRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PressRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, PressRecipe::getIngredient, (StreamCodec)ByteBufCodecs.VAR_INT, PressRecipe::getInputCount, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, PressRecipe::getResult, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, PressRecipe::getFluidResult, PressRecipe::new);

        public MapCodec<PressRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PressRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

